unit GistogramMainData01;
(*
   ========================================================================
    Gistogram
        
   : BitMap.PixelFormat = pf24bit
   ========================================================================
   ()  ,    , , .
   ========================================================================
*)
interface
uses  //  
      Windows, ExtCtrls,
      //    Image Tools
      MainData,
      //   
      EngineMainData01, GraphXYv3, VisualPointEditor01;

// ========================================================================
//
//    
//
// ========================================================================

//      
// 0 -  
// 1 -       
// 2 -   ,  , 
var GistogramCMD : byte;

// ========================================================================
//
//     
//
// ========================================================================
// ------------------------------------------------------------------------
//   
// ------------------------------------------------------------------------
//     
const //  Image     
      GistW = 256;    //  Image   ( !)
      GistH = 240;    //  Image  
      GradW = GistW;  //  ()  
      GradH = 10;     //  ()  

// ------------------------------------------------------------------------
//      
type TMDSRec = record
    //  
    MR  : extended;  //  Red
    MG  : extended;  //  Green
    MB  : extended;  //  Blue
    ML  : extended;  //  Light ()
    // 
    DR  : extended;  //  Red
    DG  : extended;  //  Green
    DB  : extended;  //  Blue
    DL  : extended;  //  Light ()
    //  
    SCoef : extended;  //     
    SR  : extended;  //  Red
    SG  : extended;  //  Green
    SB  : extended;  //  Blue
    SL  : extended;  //  Light ()
end;
// ------------------------------------------------------------------------
//      
type TChnMax =  record
   MaxR      : Longint;     //  Red
   MaxG      : Longint;     //  Green
   MaxB      : Longint;     //  Blue
   MaxL      : Longint;     // Light ()
end;
// ------------------------------------------------------------------------
//     
type TChannel =  record
   // 
   ChnR    : array [0..255] of Longint;   //  Red
   ChnG    : array [0..255] of Longint;   //  Green
   ChnB    : array [0..255] of Longint;   //  Blue
   ChnL    : array [0..255] of Longint;   // Light ()
   //      
   ChnMax  : TChnMax;
end;
// ------------------------------------------------------------------------
//       
type TGistogramRec = record
   // =========================================
   //  
   IdImg       : char;         // 'M' -  
                               // 'F' -  
   // -----------------------------------------
   //   CalculateGistograms
   ptImgTab    : ptImgTabBGR;  //     

   // -----------------------------------------
   //     
   ChnSrc      : TChannel;
   // -----------------------------------------
   //       0-255
   LightCoeff  : extended;
   // -----------------------------------------
   NumAllPnt   : cardinal;  //      ptImgTab
   NumBlackPnt : Longint;   //    
   NumWhitePnt : Longint;   //    
   // =========================================
   //   NormalizeGistogramForImage
   //  ,     
   ChnNrm      : TChannel;
   // =========================================
   //   CalcMathMDS
   MDSRec      : TMDSRec;
   // =========================================
   //  
   //      BGR
   ptBGR       : ptArrayBGR;
   //     
   WEx1, WEx2  : extended;
   //      
   ByteR, ByteG, ByteB, ByteL : byte;
   // =========================================
end;

//         
type ptGistogramRec = ^ TGistogramRec;

// ------------------------------------------------------------------------
//   
// ------------------------------------------------------------------------
//         
var ptGistRecW : ptGistogramRec;
//       
var GistRecW   : TGistogramRec;   //  

// ========================================================================
//
//        
//
// ========================================================================
// ------------------------------------------------------------------------
//      
// ------------------------------------------------------------------------
const FuncXMin = 0;   //    
      FuncXMax = 2;   //     
// ------------------------------------------------------------------------
//      
var   PointEditor : TPointEditor;
// ------------------------------------------------------------------------
//       
var  SavePArray  : TPointArray;   //    
var  PointArray  : TPointArray;   //   
// ------------------------------------------------------------------------
//      
// ------------------------------------------------------------------------
//  BGR-
type TBGR = record
    B : byte;  //  - Blue
    G : byte;  //  - Green
    R : byte;  //  - Red
end;
// ------------------------------------------------------------------------
//      
var MaxFuncNumb : integer;
//       
var FuncXE : extended;
// ------------------------------------------------------------------------
//  -     
var
  FuncTab  : array of record
  X        :  integer;    // X -   
  Y        :  integer;    // Y -    
  fVert    :  boolean;    //   
  K        :  double;    //    
end;
// ------------------------------------------------------------------------
//    -   .
var PixCCB : record
    Ind    : integer;    //  
    wXL    : double;     //    
    XL     : integer;    //  
    Found  : boolean;    //  -   
    XLB    : integer;    //     
    YLB    : integer;    //     
    wKL    : double;     //     
    YL     : integer;    //   
    mK     : double;     //   
    // -------------
    wMax   : double;     //    
    mN     : double;     //   
    // -------------
    //     
    wR, wG, wB, wL : double;
    // -------------
end;
// ------------------------------------------------------------------------

// ========================================================================
//
//  
//
// ========================================================================
// ------------------------------------------------------------------------
//    
// ------------------------------------------------------------------------
//       
const CnvAddPnt = 2;
//     ,    
type TArrExtnd  = array of extended;
//      
type TAcExtract = record
     // ---------------------
     //  
     // ---------------------
     //  
     ChoiceRow   : integer;
     ChoiceCol   : integer;
     //       
     IdRowCol    : Char;
     //     
     IdChanel    : Char;
     // ---------------------
     //    
     // ---------------------
     MDOk        : boolean;   // .    
     NumPnt      : integer;   //   
     ME          : extended;  //    
     DE          : extended;  //   
     // ---------------------
     //   
     SrcPntArr   : array of TColorByte;
     //     (   )
     SrcPntArrCM : TArrExtnd;
     //    
     FuncArr     : TArrExtnd;
     //     
     CnvlArr     : TArrExtnd;
     // ---------------------
     //     
     Graph1Arr   : TGraphArr;
     //     
     Graph2Arr   : TGraphArr;
     //      
     Graph3Arr   : TGraphArr;
end;
// ------------------------------------------------------------------------
//    
// ------------------------------------------------------------------------
//  Image  
var WorkImgAcFrg : TImage;

//    
var TabColorFrag : TImgTabColor; // array of array of record RGB;

//     
var GraphXY1 : TGraphXY;  //  
    GraphXY2 : TGraphXY;  //   
    GraphXY3 : TGraphXY;  //    

//      
var AcExtract : TAcExtract;

// ========================================================================
//   
// ========================================================================
implementation

end.
